# Dailycareers - Setup

## Files included
- public/ -> frontend (HTML/CSS/JS)
- api/ -> PHP endpoints
- sql/dailycareers.sql -> database schema

## Quick setup
1. Place `public/` in a web-accessible folder (e.g., `/var/www/html/public`) and `api/` so that `/api/*.php` is reachable by the frontend (adjust `FRONTEND_URL` in `api/config.php` if needed).
2. Create a MySQL database and import `sql/dailycareers.sql`.
3. Edit `api/db.php` and `api/config.php` to set DB and SMTP credentials.
4. Use PHP 7.4+ and enable the `mail()` function or configure SMTP/PHPMailer in `api/send-email.php` for production.
5. Use HTTPS in production and secure sessions (cookie flags, etc.).

## Notes
- This is a starter template. Add validations, CSRF protections, and rate-limiting before production.
- For a production email service, use SMTP credentials and PHPMailer or an external provider (SendGrid, Mailgun, etc.).
