<?php
require 'db.php';
$user = current_user($pdo); if(!$user){ http_response_code(401); echo json_encode(['error'=>'Unauthorized']); exit; }
$data = json_input();
$required = ['heading','company','location','category','closing_date','short_description','full_description','apply_link'];
foreach($required as $f) if(empty($data[$f])){ echo json_encode(['error'=>"Missing $f"]); exit; }
$stmt = $pdo->prepare('INSERT INTO jobs (user_id,heading,company,location,category,closing_date,short_description,full_description,apply_link,created_at) VALUES (?,?,?,?,?,?,?,?,?,NOW())');
$stmt->execute([$user['id'],$data['heading'],$data['company'],$data['location'],$data['category'],$data['closing_date'],$data['short_description'],$data['full_description'],$data['apply_link']]);
echo json_encode(['success'=>true,'job_id'=>$pdo->lastInsertId()]);
?>