<?php
require 'db.php';
require 'config.php';
require 'send-email.php';
$data = json_input();
$email = trim($data['email'] ?? '');
if(!$email){ echo json_encode(['error'=>'Missing email']); exit; }
$stmt = $pdo->prepare('SELECT id FROM users WHERE email=?');
$stmt->execute([$email]);
$user = $stmt->fetch();
if(!$user){ http_response_code(404); echo json_encode(['error'=>'Email not found']); exit; }
$token = bin2hex(random_bytes(32));
$pdo->prepare('INSERT INTO password_resets(user_id, token) VALUES(?,?)')->execute([$user['id'],$token]);
$link = FRONTEND_URL . "/reset-password.html?token=" . urlencode($token);
$body = "<p>Click the link below to reset your password:</p><p><a href='$link'>$link</a></p>";
sendMail($email,'Dailycareers — Password reset',$body);
echo json_encode(['success'=>true]);
?>