<?php
require 'db.php';
$data = json_input();
$token = trim($data['token'] ?? '');
$password = $data['password'] ?? '';
if(!$token || !$password){ echo json_encode(['error'=>'Missing fields']); exit; }
$stmt = $pdo->prepare('SELECT user_id FROM password_resets WHERE token=? AND used=0');
$stmt->execute([$token]);
$row = $stmt->fetch();
if(!$row){ http_response_code(400); echo json_encode(['error'=>'Invalid or used token']); exit; }
$new = password_hash($password, PASSWORD_DEFAULT);
$pdo->prepare('UPDATE users SET password=? WHERE id=?')->execute([$new,$row['user_id']]);
$pdo->prepare('UPDATE password_resets SET used=1 WHERE token=?')->execute([$token]);
echo json_encode(['success'=>true]);
?>