// Simple frontend logic to list jobs, open modals, register/login and post jobs via API.
let page = 1; const perPage = 6; let loading = false;

document.addEventListener('DOMContentLoaded', ()=>{
  loadJobs();
  document.getElementById('load-more').addEventListener('click', ()=>{ page++; loadJobs(); });
  document.getElementById('btn-login').addEventListener('click', openLogin);
  document.getElementById('btn-post').addEventListener('click', openPostForm);
  document.getElementById('btn-search').addEventListener('click', ()=>{ page=1; document.getElementById('jobs-grid').innerHTML=''; loadJobs(true)});
});

function loadJobs(reset=false){
  if (loading) return; loading=true;
  const q = document.getElementById('search').value || '';
  const cat = document.getElementById('filter-category').value || '';
  fetch(`/api/list_jobs.php?page=${page}&per_page=${perPage}&q=${encodeURIComponent(q)}&category=${encodeURIComponent(cat)}`, { credentials:'include'})
    .then(r=>r.json()).then(data=>{
      if (reset) document.getElementById('jobs-grid').innerHTML='';
      const grid = document.getElementById('jobs-grid');
      data.jobs.forEach(job=>{ const el = document.createElement('div'); el.className='job-card'; el.innerHTML = `\
        <h3>${escapeHtml(job.heading)}</h3>\
        <p class="meta">${escapeHtml(job.company)} — ${escapeHtml(job.location)}</p>\
        <p class="meta">Closes: ${escapeHtml(job.closing_date)}</p>\
        <p class="short">${escapeHtml(job.short_description)}</p>\
        <p><a href="/public/job.html?id=${job.id}">Read more</a></p>`; grid.appendChild(el); });
      loading=false;
    }).catch(err=>{ console.error(err); loading=false; });
}

function openLogin(){
  showModal(`
    <h3>Login</h3>
    <div class="form-group"><label>Email</label><input id="login-email" type="text"></div>
    <div class="form-group"><label>Password</label><input id="login-pass" type="password"></div>
    <div style="text-align:right"><button onclick="doLogin()" class="primary">Login</button></div>
    <p style="font-size:.9rem;margin-top:8px">No account? <a href="#" onclick="openRegister();return false">Register</a></p>
  `);
}

function openRegister(){
  showModal(`
    <h3>Register</h3>
    <div class="form-group"><label>Full name</label><input id="reg-name" type="text"></div>
    <div class="form-group"><label>Email</label><input id="reg-email" type="text"></div>
    <div class="form-group"><label>Password</label><input id="reg-pass" type="password"></div>
    <div style="text-align:right"><button onclick="doRegister()" class="primary">Create account</button></div>
  `);
}

function openPostForm(){
  fetch('/api/me.php', { credentials:'include' }).then(r=>r.json()).then(data=>{
    if (!data.user) return openLogin();
    showModal(`
      <h3>Post a Job</h3>
      <div class="form-group"><label>Heading</label><input id="j-heading" type="text"></div>
      <div class="form-group"><label>Company</label><input id="j-company" type="text"></div>
      <div class="form-group"><label>Location</label><input id="j-location" type="text"></div>
      <div class="form-group"><label>Category</label><select id="j-category">\
        <option>Learnerships</option>\
        <option>Internships</option>\
        <option>Work Integrated Learning</option>\
        <option>Graduate Programs</option>\
        <option>Grade 12</option>\
        <option>Entry Level</option>\
        <option>Jobs</option>\
      </select></div>
      <div class="form-group"><label>Closing date</label><input id="j-closing" type="date"></div>
      <div class="form-group"><label>Short description</label><textarea id="j-short" rows="3" maxlength="260"></textarea></div>
      <div class="form-group"><label>Full description</label><textarea id="j-full" rows="6"></textarea></div>
      <div class="form-group"><label>How to apply (url)</label><input id="j-link" type="text"></div>
      <div style="text-align:right"><button onclick="doPostJob()" class="primary">Post Job</button></div>
    `);
  });
}

function showModal(html){ document.getElementById('modal-content').innerHTML = html + '<div style="text-align:right;margin-top:8px"><button onclick="closeModal()">Close</button></div>'; document.getElementById('modal').classList.remove('hidden'); }
function closeModal(){ document.getElementById('modal').classList.add('hidden'); }

function doRegister(){ const name=document.getElementById('reg-name').value, email=document.getElementById('reg-email').value, pass=document.getElementById('reg-pass').value; fetch('/api/register.php',{method:'POST',credentials:'include',headers:{'Content-Type':'application/json'},body:JSON.stringify({full_name:name,email:email,password:pass})}).then(r=>r.json()).then(j=>{ if(j.success){ alert('Registered and logged in'); closeModal(); } else alert(j.error || 'Error') }); }

function doLogin(){ const email=document.getElementById('login-email').value, pass=document.getElementById('login-pass').value; fetch('/api/login.php',{method:'POST',credentials:'include',headers:{'Content-Type':'application/json'},body:JSON.stringify({email:email,password:pass})}).then(r=>r.json()).then(j=>{ if(j.success){ alert('Logged in'); closeModal(); } else alert(j.error || 'Error') }); }

function doPostJob(){ const payload = {
  heading:document.getElementById('j-heading').value,
  company:document.getElementById('j-company').value,
  location:document.getElementById('j-location').value,
  category:document.getElementById('j-category').value,
  closing_date:document.getElementById('j-closing').value,
  short_description:document.getElementById('j-short').value,
  full_description:document.getElementById('j-full').value,
  apply_link:document.getElementById('j-link').value
 };
 fetch('/api/post_job.php',{method:'POST',credentials:'include',headers:{'Content-Type':'application/json'},body:JSON.stringify(payload)}).then(r=>r.json()).then(j=>{ if(j.success){ alert('Job posted'); closeModal(); page=1; document.getElementById('jobs-grid').innerHTML=''; loadJobs(true); } else alert(j.error||'Error'); }); }

function escapeHtml(str){ if(!str) return ''; return String(str).replace(/[&<>"']/g, s=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;' }[s])); }